            # Búsqueda adicional para periodos no encontrados
for period_key in tariff_structure.get('energy', {}).keys():
    if period_key not in self.energy_prices or not self.energy_prices[period_key]:
        logging.info(f"No se encontró precio de energía para {period_key} en formato estándar, buscando formato específico...")
        
        # Buscar en formato específico de factura (Ex NNN kWh x N,NNNN €/kWh)
        period_num = period_key[1:]  # Extrae el número (1, 2, 3) de P1, P2, P3
        # Simplificamos el patrón para hacerlo más tolerante
        specific_pattern = rf'E{period_num}[^\d]+(\d+[,.])\d+[\s]*kWh[\s]*[xX][\s]*(\d+[,.]\d+)'
        specific_match = re.search(specific_pattern, self.text, re.IGNORECASE)
        logging.info(f"Buscando con patrón: {specific_pattern}")
        
        # Intento con patrones más simples adaptados a facturas españolas
        if not specific_match:
            # Usar patrón más simple sin corchetes incorrectos
            simple_pattern = rf'E{period_num}\D+(\d+[,.]\d+)\D+kWh\D+[xX]\D+(\d+[,.]\d+)'
            specific_match = re.search(simple_pattern, self.text, re.IGNORECASE)
            logging.info(f"Segundo intento con patrón: {simple_pattern}")
            
        # Un tercer intento con patrón aún más simple
        if not specific_match:
            very_simple = rf'E{period_num}.*?(\d+[,.]\d+).*?kWh.*?[xX].*?(\d+[,.]\d+)'
            specific_match = re.search(very_simple, self.text, re.IGNORECASE)
            logging.info(f"Tercer intento con patrón muy simple: {very_simple}")
            
        # Intento genérico para cualquier referencia a P1/P2/P3
        if not specific_match:
            generic_p = rf'[PE]{period_num}.*?(\d+[,.]\d+).*?[€]'
            generic_match = re.search(generic_p, self.text, re.IGNORECASE)
            if generic_match:
                logging.info(f"Encontrada referencia genérica a {period_key} con valor: {generic_match.group(1)}")
                try:
                    self.energy_prices[period_key] = float(generic_match.group(1).replace(',', '.'))
                    logging.info(f"Precio de energía para {period_key} detectado por referencia genérica: {self.energy_prices[period_key]} €/kWh")
                except (ValueError, IndexError) as e:
                    logging.warning(f"Error al convertir valor de referencia genérica para {period_key}: {e}")
        
        if specific_match:
            # Si hemos encontrado kWh x precio, extraemos el precio (segundo grupo)
            try:
                price = float(specific_match.group(2).replace(',', '.'))
                self.energy_prices[period_key] = price
                logging.info(f"Precio de energía para {period_key} detectado en formato específico: {price} €/kWh")
            except (ValueError, IndexError) as e:
                logging.warning(f"Error al extraer precio específico para {period_key}: {e}")
                # Si falla el segundo grupo, intentamos con el primer grupo que podría ser el precio
                try:
                    if len(specific_match.groups()) > 0:
                        price = float(specific_match.group(1).replace(',', '.'))
                        self.energy_prices[period_key] = price
                        logging.info(f"Precio alternativo para {period_key}: {price} €/kWh (primer grupo)")
                except (ValueError, IndexError) as e2:
                    logging.warning(f"También falló la extracción alternativa: {e2}")
