# Búsqueda adicional para periodos no encontrados
for period_key in tariff_structure.get('energy', {}).keys():
    if period_key not in self.energy_prices or not self.energy_prices[period_key]:
        logging.info(f"No se encontró precio de energía para {period_key} en formato estándar, buscando formato específico...")
        
        # Buscar en formato específico de factura (Ex NNN kWh x N,NNNN €/kWh)
        period_num = period_key[1:]  # Extrae el número (1, 2, 3) de P1, P2, P3
        # Simplificamos el patrón para hacerlo más tolerante
        specific_pattern = rf'E{period_num}[^\d]+(\d+[,.]\d+)[\s]*kWh[\s]*[xX][\s]*(\d+[,.]\d+)'
        specific_match = re.search(specific_pattern, self.text, re.IGNORECASE)
        logging.info(f"Buscando con patrón: {specific_pattern}")
        
        # Intento con patrones más simples adaptados a facturas españolas
        if not specific_match:
            # Corregimos el patrón eliminando los corchetes incorrectos
            simple_pattern = rf'E{period_num}\D+(\d+[,.]\d+)\D+kWh\D+[xX]\D+(\d+[,.]\d+)'
            specific_match = re.search(simple_pattern, self.text, re.IGNORECASE)
            logging.info(f"Segundo intento con patrón: {simple_pattern}")
            
        # Un tercer intento con patrón aún más simple
        if not specific_match:
            very_simple = rf'E{period_num}.*?(\d+[,.]\d+).*?kWh.*?[xX].*?(\d+[,.]\d+)'
            specific_match = re.search(very_simple, self.text, re.IGNORECASE)
            logging.info(f"Tercer intento con patrón muy simple: {very_simple}")
            
        # Intento genérico para cualquier referencia a P1/P2/P3
        if not specific_match:
            generic_p = rf'[PE]{period_num}.*?(\d+[,.]\d+).*?[€]'
            generic_match = re.search(generic_p, self.text, re.IGNORECASE)
            if generic_match:
                logging.info(f"Encontrada referencia genérica a {period_key} con valor: {generic_match.group(1)}")
                try:
                    self.energy_prices[period_key] = float(generic_match.group(1).replace(',', '.'))
                    logging.info(f"Precio de energía para {period_key} detectado por referencia genérica: {self.energy_prices[period_key]} €/kWh")
                except (ValueError, IndexError) as e:
                    logging.warning(f"Error al convertir valor de referencia genérica para {period_key}: {e}")
        
        if specific_match:
            try:
                self.energy_prices[period_key] = float(specific_match.group(2).replace(',', '.'))
                logging.info(f"Precio de energía para {period_key} detectado en formato específico: {self.energy_prices[period_key]} €/kWh")
                
                # También podemos extraer el consumo del mismo patrón
                consumption = float(specific_match.group(1).replace(',', '.').replace(' ', ''))
                if not self.energy_consumption.get(period_key):
                    self.energy_consumption[period_key] = consumption
                    logging.info(f"Consumo para {period_key} extraído del patrón de precio: {consumption} kWh")
            except ValueError as e:
                logging.warning(f"Error al extraer precio/consumo para {period_key} en formato específico: {str(e)}")
        # Si no encontramos con el patrón específico, usamos el patrón genérico
        elif generic_match:
            try:
                self.energy_prices[period_key] = float(generic_match.group(1).replace(',', '.'))
                logging.info(f"Precio de energía para {period_key} detectado en formato genérico: {self.energy_prices[period_key]} €/kWh")
            except ValueError as e:
                logging.warning(f"Error al extraer precio genérico para {period_key}: {str(e)}")
        else:
            # Último intento: buscar cualquier número cercano al indicador del periodo
            fallback_pattern = rf'[PE]{period_num}\D+([0-9]+[,.][0-9]+)'
            fallback_match = re.search(fallback_pattern, self.text, re.IGNORECASE)
            if fallback_match:
                try:
                    value = float(fallback_match.group(1).replace(',', '.'))
                    # Si el valor parece un precio (≤ 1)
                    if value <= 1.0:
                        self.energy_prices[period_key] = value
                        logging.info(f"Último recurso: precio para {period_key} = {value} €/kWh")
                    else:
                        logging.warning(f"El valor encontrado para {period_key} ({value}) no parece ser un precio de energía válido")
                except ValueError:
                    logging.warning(f"No se pudo convertir el valor de último recurso para {period_key}")
