#!/bin/bash

# Crear directorio de logs si no existe
mkdir -p logs

# Activar entorno virtual si existe
if [ -d "venv" ]; then
    source venv/bin/activate
fi

# Exportar variables de entorno necesarias
export FLASK_APP=manage.py
export FLASK_ENV=production

# Detener cualquier instancia previa si existe
screen -X -S ole_app quit > /dev/null 2>&1

# Iniciar Gunicorn en modo screen para que siga ejecutándose en segundo plano
# El nombre de la sesión será 'ole_app' para poder detenerla fácilmente
screen -dmS ole_app gunicorn -c gunicorn_config.py 'manage:app'

echo "Servidor iniciado en el puerto 9000"
echo "Para detener el servidor: screen -X -S ole_app quit"
echo "Para ver los logs: tail -f logs/gunicorn-error.log"
