import os
from app import create_app, db
from sqlalchemy import text

def seed_roles():
    """
    Seed the roles table with predefined roles using direct SQL statements.
    This ensures exact IDs are used as specified in the SQL statements.
    """
    config_name = os.getenv('FLASK_CONFIG') or 'default'
    app = create_app(config_name)

    with app.app_context():
        print("Contexto de la aplicación Flask establecido. Intentando sembrar roles...")
        
        # Crear roles usando SQLAlchemy ORM directamente
        from app.models.role import Role
        
        roles_data = [
            {'id': 1, 'name': 'Super Administrador', 'description': 'Acceso total a todas las funcionalidades'},
            {'id': 2, 'name': 'Agent', 'description': 'Puede ver leads, pero no descargar archivos adjuntos ni eliminar leads.'},
            {'id': 3, 'name': 'Blogger', 'description': 'Puede crear y gestionar artículos del blog y entradas FAQ'},
            {'id': 4, 'name': 'Analista de precios', 'description': 'Solo puede gestionar/cargar las tarifas de energia.'},
            {'id': 5, 'name': 'Comercial', 'description': 'Puede gestionar leads y realizar estudios de ahorro'}
        ]

        try:
            for role_data in roles_data:
                role = Role.query.filter_by(id=role_data['id']).first()
                if role:
                    # Actualizar rol existente
                    role.name = role_data['name']
                    role.description = role_data['description']
                    print(f"Rol actualizado: ID={role_data['id']}, Nombre={role_data['name']}")
                else:
                    # Crear nuevo rol
                    new_role = Role(
                        id=role_data['id'],
                        name=role_data['name'],
                        description=role_data['description']
                    )
                    db.session.add(new_role)
                    print(f"Rol creado: ID={role_data['id']}, Nombre={role_data['name']}")
            
            # Commit all changes
            db.session.commit()
            print("Todos los roles han sido sembrados correctamente en la base de datos.")
        
        except Exception as e:
            db.session.rollback()
            print(f"Ocurrió un error general: {e}")
            print("Se revirtieron los cambios en la base de datos.")

if __name__ == '__main__':
    seed_roles()
