from app import create_app
from app.models.role import Role
from app.models.user import User
from app.extensions import db

app = create_app()

with app.app_context():
    print("Creando roles...")
    
    # Crear rol Comercial si no existe
    comercial_role = Role.query.filter_by(name='Comercial').first()
    if not comercial_role:
        comercial_role = Role(name='Comercial', description='Puede gestionar leads y realizar estudios de ahorro')
        db.session.add(comercial_role)
        print("✓ Rol Comercial creado")
    else:
        print("- Rol Comercial ya existe")
    
    # Crear rol Agent si no existe
    agent_role = Role.query.filter_by(name='Agent').first()
    if not agent_role:
        agent_role = Role(name='Agent', description='Puede ver leads pero no descargar archivos ni eliminar leads')
        db.session.add(agent_role)
        print("✓ Rol Agent creado")
    else:
        print("- Rol Agent ya existe")
    
    # Guardar cambios
    db.session.commit()
    
    # Asignar rol Comercial al usuario golik
    user = User.query.filter_by(username='golik').first()
    if user and comercial_role:
        if comercial_role not in user.roles:
            user.roles.append(comercial_role)
            db.session.commit()
            print("✓ Rol Comercial asignado a golik")
        else:
            print("- golik ya tiene rol Comercial")
    
    # Mostrar roles actuales
    print("\nRoles actuales:")
    for role in Role.query.all():
        print(f"- {role.name}: {role.description}")
    
    # Verificar usuarios con rol Comercial/Agent
    print("\nUsuarios con rol Comercial o Agent:")
    commercials = User.query.join(User.roles).filter(Role.name.in_(['Comercial', 'Agent'])).all()
    for user in commercials:
        roles = [r.name for r in user.roles]
        print(f"- {user.username} ({user.name or 'Sin nombre'}): {roles}")
