from app import create_app
from app.models.legal import LegalDocument

app = create_app()

with app.app_context():
    print("Documentos legales en la base de datos:")
    documents = LegalDocument.query.all()
    
    for doc in documents:
        print(f"ID: {doc.id}, Tipo: {doc.document_type}, Título: {doc.title}, Activo: {doc.is_active}, Versión: {doc.version}")
        
    # Verificar específicamente el documento de aviso legal (terms)
    terms_doc = LegalDocument.query.filter_by(document_type='terms').all()
    print("\nDocumentos de tipo 'terms' (aviso legal):")
    for doc in terms_doc:
        print(f"ID: {doc.id}, Título: {doc.title}, Activo: {doc.is_active}, Versión: {doc.version}")
