from app import create_app

app = create_app()

with app.app_context():
    print("\n=== BLUEPRINTS REGISTRADOS ===")
    for name, blueprint in app.blueprints.items():
        print(f"Blueprint: {name}")
    
    print("\n=== TODAS LAS RUTAS ===")
    for rule in sorted(app.url_map.iter_rules(), key=lambda x: x.endpoint):
        print(f"Endpoint: {rule.endpoint}, Ruta: {rule}")
