"""add savings fields to leads

Revision ID: f1a2b3c4d5e6
Revises: e50ff3bc8d2a
Create Date: 2025-08-29 11:09:55.000000

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'f1a2b3c4d5e6'
down_revision = 'e50ff3bc8d2a'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('invoice_leads', schema=None) as batch_op:
        batch_op.add_column(sa.Column('commercial_comments', sa.Text(), nullable=True))
        batch_op.add_column(sa.Column('selected_plan', sa.String(length=255), nullable=True))
        batch_op.add_column(sa.Column('recommended_supplier', sa.String(length=255), nullable=True))
        batch_op.add_column(sa.Column('savings_history', sa.Text(), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('invoice_leads', schema=None) as batch_op:
        batch_op.drop_column('savings_history')
        batch_op.drop_column('recommended_supplier')
        batch_op.drop_column('selected_plan')
        batch_op.drop_column('commercial_comments')

    # ### end Alembic commands ###
