"""Añadir campo is_active a la tabla users

Revision ID: dc4daa549e6b
Revises: a45ff3b38f5b
Create Date: 2025-07-30 20:27:18.692207

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'dc4daa549e6b'
down_revision = 'a45ff3b38f5b'
branch_labels = None
depends_on = None


def upgrade():
    op.create_table('social_networks',
    sa.Column('id', sa.Integer(), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('icon', sa.String(length=50), nullable=True),
    sa.Column('color', sa.String(length=20), nullable=True),
    sa.Column('url_pattern', sa.String(length=255), nullable=False),
    sa.Column('is_active', sa.Boolean(), nullable=True),
    sa.Column('position', sa.Integer(), nullable=True),
    sa.Column('requires_mobile', sa.Boolean(), nullable=True),
    sa.Column('created_at', sa.DateTime(), nullable=True),
    sa.Column('updated_at', sa.DateTime(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    with op.batch_alter_table('users', schema=None) as batch_op:
        batch_op.add_column(sa.Column('is_active', sa.Boolean(), nullable=True))

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('users', schema=None) as batch_op:
        batch_op.drop_column('is_active')

    op.drop_table('social_networks')
    # No eliminamos legal_documents aquí porque no la creamos en upgrade
    # op.drop_table('legal_documents')
    # ### end Alembic commands ###
