"""Add channel and created_by_user_id to InvoiceLead

Revision ID: d00d04b420d7
Revises: 3caf233b1bf4
Create Date: 2025-08-26 15:21:26.876832

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = 'd00d04b420d7'
down_revision = '3caf233b1bf4'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('invoice_leads', schema=None) as batch_op:
        batch_op.add_column(sa.Column('created_by_user_id', sa.Integer(), nullable=True))
        batch_op.add_column(sa.Column('channel', sa.String(length=20), nullable=True))
        batch_op.create_foreign_key(None, 'users', ['created_by_user_id'], ['id'])

    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table('invoice_leads', schema=None) as batch_op:
        batch_op.drop_constraint(None, type_='foreignkey')
        batch_op.drop_column('channel')
        batch_op.drop_column('created_by_user_id')

    # ### end Alembic commands ###
