from app import create_app
from app.extensions import db
import sqlite3
import os
from flask_migrate import Migrate

# Crear la aplicación y contexto
app = create_app()
migrate = Migrate(app, db)

def check_column_exists(conn, table, column):
    """Comprueba si una columna existe en una tabla"""
    cursor = conn.cursor()
    cursor.execute(f"PRAGMA table_info({table})")
    columns = cursor.fetchall()
    return any(col[1] == column for col in columns)

def run_migration():
    with app.app_context():
        # Ruta directa a la base de datos SQLite de desarrollo
        base_dir = os.path.abspath(os.path.dirname(__file__))
        db_path = os.path.join(base_dir, 'instance', 'ole_consulting_dev.db')
        print(f"Buscando base de datos en: {db_path}")
        
        # Verificar que el archivo existe
        if not os.path.exists(db_path):
            print(f"ERROR: La base de datos no existe en la ruta {db_path}")
            return
            
        conn = sqlite3.connect(db_path)
        
        # Verificar si la columna ya existe
        if not check_column_exists(conn, 'users', 'is_active'):
            print("Añadiendo columna 'is_active' a la tabla 'users'...")
            conn.execute("ALTER TABLE users ADD COLUMN is_active BOOLEAN DEFAULT 1")
            conn.commit()
            print("¡Migración completada con éxito!")
        else:
            print("La columna 'is_active' ya existe en la tabla 'users'.")
        
        conn.close()

if __name__ == '__main__':
    run_migration()
