import os
from app import create_app, db
from app.models.role import Role

def run_init_roles():
    config_name = os.getenv('FLASK_CONFIG') or 'default'
    app = create_app(config_name)

    with app.app_context():
        print("Contexto de la aplicación Flask establecido. Intentando crear roles...")
        
        roles_to_create = [
            (1, "Super Administrador", "Acceso total a todas las funcionalidades"),
            (2, "Agente", "Puede ver leads, pero no descargar archivos adjuntos ni eliminar leads."),
            (3, "Blogger", "Puede crear y gestionar artículos del blog y entradas FAQ"),
            (4, "Analista de precios", "Solo puede gestionar/cargar las tarifas de energia."),
            (5, "Comercial", "Puede ver tarifas y leads, pero no puede modificar o eliminar registros.")
        ]

        try:
            for role_id, role_name, role_description in roles_to_create:
                role = Role.query.filter_by(id=role_id).first()
                if not role:
                    role = Role(id=role_id, name=role_name, description=role_description)
                    db.session.add(role)
                    print(f"Rol '{role_name}' (ID: {role_id}) creado.")
                else:
                    # Update existing role to ensure consistency
                    role.name = role_name
                    role.description = role_description
                    print(f"Rol '{role_name}' (ID: {role_id}) actualizado.")
            
            db.session.commit()
            print("Roles iniciales verificados/creados y cambios guardados en la base de datos.")
        
        except Exception as e:
            db.session.rollback()
            print(f"Ocurrió un error: {e}")
            print("Se revirtieron los cambios en la base de datos.")

if __name__ == '__main__':
    run_init_roles()
