"""
Configuración de Gunicorn para la aplicación OLE-CONSULTING
"""

import multiprocessing
import os

# Configuración básica
bind = "0.0.0.0:9000"
workers = multiprocessing.cpu_count() * 2 + 1
worker_class = "sync"
timeout = 120
keepalive = 5

# Configuración de logs
errorlog = "logs/gunicorn-error.log"
accesslog = "logs/gunicorn-access.log"
loglevel = "debug"

# Configuración de la aplicación
wsgi_app = "manage:app"

# Configuración de seguridad
limit_request_line = 4094
limit_request_fields = 100
limit_request_field_size = 8190

# Configuración de rendimiento
worker_connections = 1000
max_requests = 1000
max_requests_jitter = 50

# Crear directorio de logs si no existe
logdir = "logs"
os.makedirs(logdir, exist_ok=True)
