#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re

# Abre el archivo con el encoding correcto
with open('app/services/tariff_detector.py', 'r', encoding='utf-8') as file:
    content = file.read()

# Corrige el problema de la definición del método _extract_consumos_optimizado
fixed_content = re.sub(
    r'def _extract_consumos_optimizado\(self\):\s+""".*?"""\s+periods = \[.*?\].*?logging\.info\("Extrayendo consumos.*?\).*?logging\.info\("Iniciando extracción',
    'def _extract_consumos_optimizado(self):\n        """Método optimizado para extracción de consumos energéticos por periodo.\n        Utiliza patrones más robustos y búsqueda más exhaustiva con mejor diagnóstico."""\n        periods = [\'P1\', \'P2\', \'P3\', \'P4\', \'P5\', \'P6\']\n        logging.info("Extrayendo consumos energéticos con método optimizado")\n        logging.info("Iniciando extracción',
    content,
    flags=re.DOTALL
)

# Corregir posibles problemas de indentación en las líneas problemáticas
fixed_content = re.sub(
    r'\n(\s+if logging\.getLogger\(\)\.isEnabledFor\(logging\.DEBUG\):)',
    '\n        if logging.getLogger().isEnabledFor(logging.DEBUG):',
    fixed_content
)

# Guarda el archivo corregido
with open('app/services/tariff_detector.py', 'w', encoding='utf-8') as file:
    file.write(fixed_content)

print("Corrección de indentación completada.")
