#!/usr/bin/env python
# -*- coding: utf-8 -*-

import re

# Función para corregir problemas de indentación específicos en el archivo tariff_detector.py
def fix_indentation():
    # Ruta al archivo
    file_path = 'app/services/tariff_detector.py'
    
    # Leer el contenido del archivo
    with open(file_path, 'r', encoding='utf-8') as f:
        content = f.read()
    
    # Lista para almacenar las líneas de contenido
    lines = content.split('\n')
    
    # Corrección 1: Línea 1541 - Ajustar la indentación
    if len(lines) >= 1541:
        # Asegurarse de que la indentación sea correcta
        # Este es un punto específico donde puede estar mezclando espacios y tabulaciones
        lines[1540] = lines[1540].rstrip()  # Eliminar espacios o tabs al final
    
    # Corrección 2: Línea 1692 - Verificar decorador o indentación incorrecta
    if len(lines) >= 1692:
        # Si esta línea está mal indentada o falta alguna definición después de un decorador
        # Ajustar según sea necesario
        lines[1691] = lines[1691].rstrip()
    
    # Corrección 3: Línea 1726 - Resolver problema de indentación inesperada
    if len(lines) >= 1726:
        # Ajustar la indentación para que sea consistente con los bloques circundantes
        lines[1725] = lines[1725].rstrip()
        # Ajustar líneas circundantes si es necesario
        if len(lines) >= 1727:
            lines[1726] = lines[1726].rstrip()
    
    # Reconstruir el contenido
    new_content = '\n'.join(lines)
    
    # Guardar los cambios
    with open(file_path + '.fixed', 'w', encoding='utf-8') as f:
        f.write(new_content)
    
    print(f"Archivo corregido guardado como {file_path}.fixed")
    print("Revise este archivo y compárelo con el original.")
    print("Si las correcciones son apropiadas, renombre el archivo .fixed a .py")

if __name__ == "__main__":
    fix_indentation()
