#!/usr/bin/env python
# -*- coding: utf-8 -*-
"""
Script para corregir las rutas de imágenes en la base de datos
"""
import os
import sys
from flask import Flask
from app import create_app, db
from app.models.article import Article

def fix_image_paths():
    """Corrige las rutas de imágenes en la base de datos"""
    print("Iniciando corrección de rutas de imágenes...")
    
    # Crear la aplicación Flask con la configuración de desarrollo
    app = create_app('development')
    
    with app.app_context():
        # Obtener todos los artículos con imágenes
        articles = Article.query.filter(Article.featured_image.isnot(None)).all()
        
        count = 0
        for article in articles:
            original_path = article.featured_image
            if original_path and not original_path.startswith('/static/'):
                # Corregir rutas que no comienzan con /static/
                if original_path.startswith('uploads/'):
                    # Ruta relativa a static
                    new_path = f"/static/{original_path}"
                    article.featured_image = new_path
                    count += 1
                    print(f"Actualizada imagen: {original_path} -> {new_path}")
        
        # Guardar los cambios si hay alguno
        if count > 0:
            db.session.commit()
            print(f"Se actualizaron {count} rutas de imágenes correctamente.")
        else:
            print("No se encontraron rutas de imágenes que necesiten corrección.")

if __name__ == "__main__":
    fix_image_paths()
    print("Proceso completado.")
