def _extract_power_and_prices(self):
    """Método especializado para extraer potencia contratada y precios de energía/potencia.
    Implementa una búsqueda exhaustiva con patrones mejorados para facturas españolas."""
    logging.info("Iniciando extracción de potencia contratada y precios")
    
    # 1. Extraer potencia contratada con múltiples patrones
    if not self.contracted_power:
        power_match = None
        for pattern in [self.CONTRACTED_POWER_PATTERN, self.ALT_CONTRACTED_POWER_PATTERN]:
            power_match = re.search(pattern, self.text, re.IGNORECASE)
            if power_match:
                try:
                    value = power_match.group(1).replace(',', '.').strip()
                    self.contracted_power = float(value)
                    logging.info(f"Potencia contratada detectada: {self.contracted_power} kW")
                    break
                except (ValueError, IndexError) as e:
                    logging.warning(f"Error al convertir potencia contratada: {e}")
        
        # Si no se encontró con los patrones principales, buscar usando patrones específicos por periodo
        if not self.contracted_power:
            logging.info("Intentando detectar potencia contratada por periodos")
            total_power = 0
            power_count = 0
            
            for period, pattern in self.POWER_PATTERNS.items():
                power_match = pattern.search(self.text)
                if power_match:
                    try:
                        value = float(power_match.group(1).replace(',', '.').strip())
                        self.power_by_period[period] = value
                        total_power += value
                        power_count += 1
                        logging.info(f"Potencia {period} detectada: {value} kW")
                    except (ValueError, IndexError) as e:
                        logging.warning(f"Error al convertir potencia para {period}: {e}")
            
            # Si se encontraron potencias por periodo, calcular el total o promedio
            if power_count > 0:
                # Para algunas tarifas la potencia contratada es la suma, para otras es igual en todos los periodos
                # Como heurística, si son muy similares usar una, si hay variación usar la suma
                values = list(self.power_by_period.values())
                if values and max(values) - min(values) < 0.1:
                    # Si son casi iguales, usar el primer valor
                    self.contracted_power = values[0]
                    logging.info(f"Potencia contratada inferida (igual en periodos): {self.contracted_power} kW")
                else:
                    # Si hay diferencias, usar la suma
                    self.contracted_power = total_power
                    logging.info(f"Potencia contratada inferida (suma de periodos): {self.contracted_power} kW")
    
    # 2. Extraer precios de energía por periodo
    logging.info("Detectando precios de energía por periodos")
    for period, pattern in self.ENERGY_PRICE_PATTERNS.items():
        price_match = pattern.search(self.text)
        if price_match:
            try:
                price = float(price_match.group(1).replace(',', '.').strip())
                self.energy_prices[period] = price
                logging.info(f"Precio de energía para {period} detectado: {price} €/kWh")
            except (ValueError, IndexError) as e:
                logging.warning(f"Error al convertir precio de energía para {period}: {e}")
    
    # Si no se encontró ningún precio por periodo, intentar con precio genérico
    if not any(self.energy_prices.values()):
        logging.info("Intentando detectar precio de energía genérico")
        generic_price_match = re.search(self.GENERIC_ENERGY_PRICE_PATTERN, self.text, re.IGNORECASE)
        if generic_price_match:
            try:
                price = float(generic_price_match.group(1).replace(',', '.').strip())
                # Aplicar el mismo precio a todos los periodos
                for period in ['P1', 'P2', 'P3']:
                    self.energy_prices[period] = price
                logging.info(f"Precio genérico detectado y aplicado a todos los periodos: {price} €/kWh")
            except (ValueError, IndexError) as e:
                logging.warning(f"Error al convertir precio genérico: {e}")
                
    # 3. Extraer precios de potencia
    logging.info("Detectando precios de potencia por periodos")
    for period, pattern in self.POWER_PRICE_PATTERNS.items():
        power_price_match = pattern.search(self.text)
        if power_price_match:
            try:
                price = float(power_price_match.group(1).replace(',', '.').strip())
                self.power_prices[period] = price
                logging.info(f"Precio de potencia para {period} detectado: {price} €/kW")
            except (ValueError, IndexError) as e:
                logging.warning(f"Error al convertir precio de potencia para {period}: {e}")
