# Guía de estilo — Modal de Detalle de Tarifas

Esta guía resume las decisiones visuales acordadas para el modal de detalle de tarifas y servirá como referencia para futuros ajustes.

## Colores corporativos
- Azul corporativo: `#0b99fd` (CSS var `--brand-blue`)
- Magenta corporativo: `#bd05dc` (CSS var `--brand-magenta`)

Definidos actualmente dentro del scope `.rate-detail-modal` para evitar fugas de estilos.

## Iconografía por sección
- ID: `fa-barcode`
- Comercializadora: `fa-building`
- Nombre: `fa-file-signature`
- Tipo: `fa-bolt`
- Período de validez: `fa-calendar-check`
- Notas: `fa-info-circle`
- Energía: `fa-lightbulb`
- Potencia: `fa-battery-full`

## Estructura y cards
- Cards afectadas: `.info-card`, `.date-card`, `.notes-card`, `.prices-card`
- Base común (todas):
  - Borde: `1px solid #e9ecef`
  - Radio: `10px`
  - Sombra base: `0 2px 6px rgba(33,37,41,0.06)`
  - Fondo: `#fff`
  - Transiciones: `box-shadow .2s ease, transform .2s ease`
- Acentos laterales:
  - `.info-card`: borde izquierdo `--brand-blue`; padding `14px 16px`
  - `.date-card`: borde izquierdo `--brand-magenta`
  - `.notes-card`: borde izquierdo `#e0e0e0`
  - `.prices-card`: sin acento lateral por ahora (se puede añadir si se desea)
- Encabezados (`.card-header`):
  - Por defecto: fondo `#f8f9fa`, borde inferior `#e9ecef`, radio superior heredado
  - Excepciones actuales:
    - Energía: header con fondo azul corporativo (`#0b99fd`) y `text-white`
    - Potencia: header `bg-success` y `text-white`

## Hover y elevación
- Efecto hover aplicado a: `.info-card`, `.date-card`, `.notes-card`, `.prices-card`
- Efecto: `transform: translateY(-2px)` + `box-shadow: 0 10px 22px rgba(33,37,41,0.12)`

## Tipografía y espaciados
- Labels (`.detail-label`): `font-size: .82rem`, color `#6c757d`, `margin-bottom: 4px`, alineación con icono
- Valores (`.detail-value`): `font-weight: 500`, con `overflow-wrap: anywhere` y `word-break: break-word`
- ID resaltado: `fw-bold fs-5`

## Responsividad
- Contenedor modal: `max-width: 800px`; `max-height: 85vh`; scroll interno en body
- En `< 768px`:
  - `max-width: 95%`, `max-height: 90vh`
  - `.info-card` padding `12px`
  - `date/notes .card-body` con padding lateral reducido

## Implementación técnica
- Estilos en línea dentro del template `admin/rates/list.html`, bloque `<style>` bajo el modal, con scope `.rate-detail-modal` para máxima prioridad.
- Badge del tipo (`#d_tariff_type`) forzado a azul corporativo.
- Icono de cabecera del modal (`.custom-modal-header .fa-bolt`) en azul corporativo.

## Cómo extender
- Nuevas tarjetas: usar `.prices-card` para heredar base y hover.
- Acento lateral opcional: añadir regla específica `.new-card { border-left: 4px solid var(--brand-...); }`.
- Si se desea globalizar variables de color, mover a `:root` en `static/css/admin_custom.css` y ajustar selectores con igual o mayor especificidad.
