from app import create_app
import sys

app = create_app()

with app.app_context():
    print("Blueprints registrados y sus rutas:")
    for name, blueprint in app.blueprints.items():
        print(f"\nBlueprint: {name}")
        for rule in app.url_map.iter_rules():
            if rule.endpoint.startswith(name + '.'):
                print(f"  Ruta: {rule}, Endpoint: {rule.endpoint}")
    
    # Buscar específicamente las rutas del blueprint commercial_invoice
    print("\nBuscando específicamente rutas de commercial_invoice:")
    found = False
    for rule in app.url_map.iter_rules():
        if rule.endpoint.startswith('commercial_invoice.'):
            found = True
            print(f"  Ruta: {rule}, Endpoint: {rule.endpoint}")
    
    if not found:
        print("  ¡No se encontraron rutas para commercial_invoice!")
        sys.exit(1)
