from app import create_app, db
from app.models import User, Role
from werkzeug.security import generate_password_hash
import getpass

def create_super_admin():
    # Configurar la aplicación
    app = create_app()
    
    with app.app_context():
        # Crear el rol de Super Administrador si no existe
        role_name = 'Super Administrador'
        super_admin_role = Role.query.filter_by(name=role_name).first()
        
        if not super_admin_role:
            super_admin_role = Role(name=role_name, description='Acceso total al sistema')
            db.session.add(super_admin_role)
            db.session.commit()
            print(f"Rol '{role_name}' creado exitosamente.")
        
        # Solicitar datos del nuevo administrador
        print("\n=== Creación de Usuario Super Administrador ===")
        username = input("Nombre de usuario: ").strip()
        email = input("Correo electrónico: ").strip().lower()
        
        # Verificar si el usuario ya existe
        if User.query.filter((User.username == username) | (User.email == email)).first():
            print("Error: Ya existe un usuario con ese nombre de usuario o correo electrónico.")
            return
        
        # Solicitar contraseña de forma segura
        while True:
            password = getpass.getpass("Contraseña: ")
            confirm_password = getpass.getpass("Confirmar contraseña: ")
            if password == confirm_password and len(password) >= 8:
                break
            print("Error: Las contraseñas no coinciden o tienen menos de 8 caracteres. Intente de nuevo.")
        
        # Crear el usuario
        new_admin = User(
            username=username,
            email=email,
            is_active=True
        )
        new_admin.set_password(password)
        new_admin.roles.append(super_admin_role)
        
        # Guardar en la base de datos
        db.session.add(new_admin)
        db.session.commit()
        
        print(f"\n¡Usuario '{username}' creado exitosamente con rol de Super Administrador!")
        print(f"Email: {email}")
        print("\n¡Recuerde guardar esta información en un lugar seguro!")

if __name__ == "__main__":
    create_super_admin()
