import mysql.connector
import os
from dotenv import load_dotenv

# Cargar variables de entorno
load_dotenv()

# Configuración de la base de datos
config = {
    'host': 'localhost',
    'user': 'root',
    'password': os.getenv('MYSQL_ROOT_PASSWORD', ''),
    'database': 'ole_consulting',
    'port': 3306
}

try:
    # Conectar a MySQL
    conn = mysql.connector.connect(**config)
    cursor = conn.cursor()
    
    print("Conectado a MySQL exitosamente")
    
    # Verificar roles existentes
    cursor.execute("SELECT id, name FROM roles")
    existing_roles = cursor.fetchall()
    print(f"Roles existentes: {existing_roles}")
    
    # Crear roles faltantes
    roles_to_create = [
        (2, 'Comercial', 'Puede gestionar leads y realizar estudios de ahorro'),
        (3, 'Agent', 'Puede ver leads pero no descargar archivos ni eliminar leads'),
        (4, 'Blogger', 'Puede crear y gestionar artículos del blog'),
        (5, 'Analista de precios', 'Solo puede gestionar tarifas de energía')
    ]
    
    for role_id, name, description in roles_to_create:
        # Verificar si el rol ya existe
        cursor.execute("SELECT id FROM roles WHERE id = %s OR name = %s", (role_id, name))
        if not cursor.fetchone():
            cursor.execute(
                "INSERT INTO roles (id, name, description) VALUES (%s, %s, %s)",
                (role_id, name, description)
            )
            print(f"✓ Rol creado: {name}")
        else:
            print(f"- Rol ya existe: {name}")
    
    # Confirmar cambios
    conn.commit()
    
    # Verificar roles después de la inserción
    cursor.execute("SELECT id, name, description FROM roles")
    all_roles = cursor.fetchall()
    print("\nRoles actuales en la base de datos:")
    for role in all_roles:
        print(f"  {role[0]}: {role[1]} - {role[2]}")
    
    # Asignar rol Comercial al usuario golik
    cursor.execute("SELECT id FROM users WHERE username = 'golik'")
    user_result = cursor.fetchone()
    
    if user_result:
        user_id = user_result[0]
        cursor.execute("SELECT id FROM roles WHERE name = 'Comercial'")
        role_result = cursor.fetchone()
        
        if role_result:
            role_id = role_result[0]
            
            # Verificar si ya tiene el rol asignado
            cursor.execute(
                "SELECT 1 FROM user_roles WHERE user_id = %s AND role_id = %s",
                (user_id, role_id)
            )
            
            if not cursor.fetchone():
                cursor.execute(
                    "INSERT INTO user_roles (user_id, role_id) VALUES (%s, %s)",
                    (user_id, role_id)
                )
                conn.commit()
                print(f"✓ Rol Comercial asignado al usuario golik")
            else:
                print("- Usuario golik ya tiene el rol Comercial")
    
    # Verificar usuarios con roles Comercial o Agent
    cursor.execute("""
        SELECT u.username, u.name, r.name as role_name
        FROM users u
        JOIN user_roles ur ON u.id = ur.user_id
        JOIN roles r ON ur.role_id = r.id
        WHERE r.name IN ('Comercial', 'Agent')
    """)
    
    commercial_users = cursor.fetchall()
    print(f"\nUsuarios con rol Comercial o Agent: {len(commercial_users)}")
    for user in commercial_users:
        print(f"  - {user[0]} ({user[1] or 'Sin nombre'}): {user[2]}")

except mysql.connector.Error as err:
    print(f"Error de MySQL: {err}")
except Exception as e:
    print(f"Error general: {e}")
finally:
    if 'conn' in locals() and conn.is_connected():
        cursor.close()
        conn.close()
        print("\nConexión cerrada")
