#!/usr/bin/env python
"""
Script para crear los roles faltantes en la base de datos
"""

from app import create_app
from app.models.user import User
from app.models.role import Role
from app.extensions import db

def create_missing_roles():
    app = create_app()
    
    with app.app_context():
        print("=== CREANDO ROLES FALTANTES ===\n")
        
        # Roles que deberían existir según la memoria del usuario
        required_roles = [
            {'name': 'Super Admin', 'description': 'Full access to all application features'},
            {'name': 'Agent', 'description': 'Can view leads but cannot download lead invoice files or delete leads'},
            {'name': 'Blogger', 'description': 'Can create, edit, and manage blog articles and FAQ entries'},
            {'name': 'Price Analyst', 'description': 'Can only manage (upload/update) energy tariffs'},
            {'name': 'Comercial', 'description': 'Puede gestionar leads y realizar estudios de ahorro'}
        ]
        
        created_roles = []
        
        for role_data in required_roles:
            # Verificar si el rol ya existe
            existing_role = Role.query.filter_by(name=role_data['name']).first()
            
            if not existing_role:
                # Crear el rol
                new_role = Role(
                    name=role_data['name'],
                    description=role_data['description']
                )
                db.session.add(new_role)
                created_roles.append(role_data['name'])
                print(f"✓ Creado rol: {role_data['name']}")
            else:
                print(f"- Rol ya existe: {role_data['name']}")
        
        # Guardar cambios
        if created_roles:
            try:
                db.session.commit()
                print(f"\n✓ Se crearon {len(created_roles)} roles nuevos")
            except Exception as e:
                db.session.rollback()
                print(f"\n✗ Error al crear roles: {e}")
                return False
        else:
            print("\n- No se necesitaron crear roles nuevos")
        
        # Mostrar todos los roles actuales
        print("\n=== ROLES ACTUALES EN LA BASE DE DATOS ===")
        all_roles = Role.query.all()
        for role in all_roles:
            print(f"   - {role.name}: {role.description}")
        
        # Crear un usuario comercial de ejemplo si no existe
        print("\n=== CREANDO USUARIO COMERCIAL DE EJEMPLO ===")
        comercial_user = User.query.filter_by(username='comercial_test').first()
        
        if not comercial_user:
            comercial_role = Role.query.filter_by(name='Comercial').first()
            if comercial_role:
                new_user = User(
                    username='comercial_test',
                    email='comercial@test.com',
                    name='Comercial Test'
                )
                new_user.set_password('test123')
                new_user.roles.append(comercial_role)
                
                db.session.add(new_user)
                try:
                    db.session.commit()
                    print("✓ Usuario comercial de prueba creado: comercial_test / test123")
                except Exception as e:
                    db.session.rollback()
                    print(f"✗ Error al crear usuario comercial: {e}")
            else:
                print("✗ No se pudo encontrar el rol Comercial")
        else:
            print("- Usuario comercial de prueba ya existe")
        
        return True

if __name__ == "__main__":
    create_missing_roles()
