"""
INSTRUCCIONES PARA CORREGIR LOS ERRORES DE INDENTACIÓN EN tariff_detector.py

Reemplaza las siguientes secciones de código en sus correspondientes ubicaciones para corregir 
los errores de indentación detectados.
"""

# Sección corregida para _extract_power_and_prices
def _extract_power_and_prices(self):
    """Extrae potencia contratada y precios de energía y potencia."""
    logging.info("Extrayendo potencia contratada y precios de energía y potencia...")

    # Patrones de expresiones regulares para encontrar potencia contratada
    power_patterns = [
        r'[Pp]otencia\s*[Cc]ontratada\s*[:=]?\s*(\d+(?:[.,]\d+)?)\s*kW',
        r'[Pp]otencia\s*[:=]?\s*(\d+(?:[.,]\d+)?)\s*kW',
        r'[Pp]\s*[:=]?\s*(\d+(?:[.,]\d+)?)\s*kW',
        r'[Tt]érmino\s*[Dd]e\s*[Pp]otencia\s*[:=]?\s*(\d+(?:[.,]\d+)?)\s*kW',
    ]
    
    # Detectar potencia contratada en el texto
    self.power = None
    for pattern in power_patterns:
        matches = re.finditer(pattern, self.text)
        for match in matches:
            value_str = match.group(1).replace(',', '.')
            try:
                power_value = float(value_str)
                if 1.0 < power_value < 50.0:  # Rango razonable para potencia en kW
                    self.power = power_value
                    break
            except ValueError:
                continue
        if self.power:
            break
    
    # Patrones para detectar precios de energía
    energy_price_patterns = {
        'P1': [
            r'[Pp]recio\s*[Ee]nergía\s*[Pp](?:1|unta)\s*[:=]\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
            r'[Pp](?:1|unta)\s*[:=]?\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
            r'[Ee]nergía\s*[Pp](?:1|unta)(?:[^\d\n]{0,50})(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
        ],
        'P2': [
            r'[Pp]recio\s*[Ee]nergía\s*[Pp](?:2|lano)\s*[:=]\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
            r'[Pp](?:2|lano)\s*[:=]?\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
            r'[Ee]nergía\s*[Pp](?:2|lano)(?:[^\d\n]{0,50})(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
        ],
        'P3': [
            r'[Pp]recio\s*[Ee]nergía\s*[Pp](?:3|valle)\s*[:=]\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
            r'[Pp](?:3|valle)\s*[:=]?\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
            r'[Ee]nergía\s*[Pp](?:3|valle)(?:[^\d\n]{0,50})(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kWh|kwh)',
        ]
    }
    
    # Patrones para detectar precios de potencia
    power_price_patterns = {
        'P1': [
            r'[Pp]recio\s*[Pp]otencia\s*[Pp](?:1|unta)\s*[:=]\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kW|kw)',
            r'[Pp]otencia\s*[Pp](?:1|unta)\s*[:=]?\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kW|kw)',
            r'[Tt]érmino\s*[Dd]e\s*[Pp]otencia\s*[Pp](?:1|unta)[^\d\n]{0,50}(\d+[.,]?\d*)'
        ],
        'P2': [
            r'[Pp]recio\s*[Pp]otencia\s*[Pp](?:2|lano)\s*[:=]\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kW|kw)',
            r'[Pp]otencia\s*[Pp](?:2|lano)\s*[:=]?\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kW|kw)',
            r'[Tt]érmino\s*[Dd]e\s*[Pp]otencia\s*[Pp](?:2|lano)[^\d\n]{0,50}(\d+[.,]?\d*)'
        ],
        'P3': [
            r'[Pp]recio\s*[Pp]otencia\s*[Pp](?:3|valle)\s*[:=]\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kW|kw)',
            r'[Pp]otencia\s*[Pp](?:3|valle)\s*[:=]?\s*(\d+[.,]?\d*)\s*(?:€|EUR)\s*(?:/|por)\s*(?:kW|kw)',
            r'[Tt]érmino\s*[Dd]e\s*[Pp]otencia\s*[Pp](?:3|valle)[^\d\n]{0,50}(\d+[.,]?\d*)'
        ]
    }
