#!/usr/bin/env python
"""
Script para verificar usuarios y roles en la base de datos
"""

from app import create_app
from app.models.user import User
from app.models.role import Role

def check_users_and_roles():
    app = create_app()
    
    with app.app_context():
        print("=== VERIFICACIÓN DE USUARIOS Y ROLES ===\n")
        
        # Verificar todos los roles
        print("1. ROLES DISPONIBLES:")
        roles = Role.query.all()
        for role in roles:
            print(f"   - {role.name} (ID: {role.id})")
        
        print(f"\nTotal de roles: {len(roles)}\n")
        
        # Verificar todos los usuarios
        print("2. USUARIOS DISPONIBLES:")
        users = User.query.all()
        for user in users:
            user_roles = [r.name for r in user.roles]
            print(f"   - {user.username} ({user.name or 'Sin nombre'}) - Roles: {user_roles}")
        
        print(f"\nTotal de usuarios: {len(users)}\n")
        
        # Verificar usuarios con rol Comercial o Agent
        print("3. USUARIOS CON ROL COMERCIAL O AGENT:")
        commercials = User.query.join(User.roles).filter(
            Role.name.in_(['Comercial', 'Agent'])
        ).all()
        
        if commercials:
            for user in commercials:
                user_roles = [r.name for r in user.roles]
                print(f"   - {user.username} ({user.name or 'Sin nombre'}) - Roles: {user_roles}")
        else:
            print("   No se encontraron usuarios con rol Comercial o Agent")
        
        print(f"\nTotal de comerciales: {len(commercials)}\n")
        
        # Verificar estructura de la consulta
        print("4. PRUEBA DE CONSULTA API:")
        try:
            commercial_list = [{
                'id': c.id,
                'name': c.name or c.username,
                'username': c.username,
                'email': c.email
            } for c in commercials]
            
            print("   Respuesta que devolvería la API:")
            print(f"   {{'success': True, 'commercials': {commercial_list}}}")
        except Exception as e:
            print(f"   Error en la consulta: {e}")

if __name__ == "__main__":
    check_users_and_roles()
