from app import create_app
from app.models.article import Article

def main():
    app = create_app()
    
    with app.app_context():
        articles = Article.query.order_by(Article.published_at.desc()).all()
        print(f"Total de artículos en la base de datos: {len(articles)}")
        for article in articles:
            print(f"- {article.title} (Publicado: {article.is_published}, Fecha: {article.published_at})")

if __name__ == "__main__":
    main()
