from app import create_app, db
from app.models.user import User

app = create_app()
with app.app_context():
    user = User.query.filter_by(username='carlo.golik').first()
    if user:
        print(f'Usuario: {user.username}, Email: {user.email}, Es Admin: {user.is_admin}')
        if not user.is_admin:
            print('Asignando permisos de administrador...')
            user.is_admin = True
            db.session.commit()
            print('¡Permisos de administrador actualizados correctamente!')
        else:
            print('El usuario ya tiene permisos de administrador.')
    else:
        print('Usuario no encontrado. Creando nuevo administrador...')
        admin = User(username='carlo.golik', 
                    email='carlo.golik@oleconsulting.es',
                    is_admin=True)
        admin.set_password('20222456')
        db.session.add(admin)
        db.session.commit()
        print('Usuario administrador creado exitosamente.')
