# assign_super_admin.py
from app import create_app, db
from app.models import User, Role

# Obtener la instancia de la aplicación Flask y configurar el contexto de la aplicación
# Esto es necesario para que las consultas a la base de datos y otras extensiones de Flask funcionen.
app = create_app() 

with app.app_context():
    user_email = 'carlo.golik@oleconsulting.es'
    role_name = 'Super Administrador'

    # Buscar el usuario por su dirección de correo electrónico
    user = User.query.filter_by(email=user_email).first()

    if user:
        print(f"INFO: Usuario encontrado: {user.username} (ID: {user.id})")
        
        # Buscar el rol 'Super Administrador' en la base de datos
        super_admin_role = Role.query.filter_by(name=role_name).first()
        
        if super_admin_role:
            print(f"INFO: Rol encontrado: {super_admin_role.name} (ID: {super_admin_role.id})")
            
            # Verificar si el usuario ya tiene el rol asignado
            if super_admin_role not in user.roles:
                # Si no lo tiene, asignar el rol al usuario
                user.roles.append(super_admin_role)
                db.session.commit() # Guardar los cambios en la base de datos
                print(f"SUCCESS: Rol '{super_admin_role.name}' asignado a {user.username}.")
            else:
                print(f"INFO: {user.username} ya tiene el rol '{super_admin_role.name}'.")
        else:
            # Mensaje de error si el rol 'Super Administrador' no se encuentra
            print(f"ERROR: El rol '{role_name}' no se encontró en la base de datos. "
                  "Asegúrate de que el script 'init_roles.py' se haya ejecutado correctamente "
                  "y que los roles iniciales existan.")
    else:
        # Mensaje de error si no se encuentra el usuario con el correo electrónico especificado
        print(f"ERROR: Usuario con email '{user_email}' no encontrado. "
              "Verifica que el correo electrónico sea correcto y que el usuario exista en la base de datos.")

print("INFO: Script finalizado.")
