// JavaScript principal para Olé Consulting

document.addEventListener('DOMContentLoaded', function() {
    console.log('Olé Consulting JS cargado.');

    // Ejemplo: Smooth scroll para anclas (si se usa)
    // document.querySelectorAll('a[href^="#"]').forEach(anchor => {
    //     anchor.addEventListener('click', function (e) {
    //         e.preventDefault();
    //         document.querySelector(this.getAttribute('href')).scrollIntoView({
    //             behavior: 'smooth'
    //         });
    //     });
    // });

    // Lógica para el popup del formulario "Estudio gratuito"
    // Esto es un ejemplo básico, se puede mejorar con Alpine.js u otra librería
    const ctaButtons = document.querySelectorAll('.open-popup-estudio'); // Asigna esta clase a los botones CTA
    const popup = document.getElementById('popup-estudio-gratuito'); // Asigna este ID al div del popup
    const closePopupButton = document.getElementById('close-popup-estudio'); // Asigna este ID al botón de cerrar popup

    if (popup) {
        ctaButtons.forEach(button => {
            button.addEventListener('click', function() {
                popup.style.display = 'flex'; // O 'block', dependiendo de cómo lo estiles
            });
        });

        if (closePopupButton) {
            closePopupButton.addEventListener('click', function() {
                popup.style.display = 'none';
            });
        }

        // Cerrar popup si se hace clic fuera del contenido del popup
        popup.addEventListener('click', function(event) {
            if (event.target === popup) { // Si el clic es en el fondo del popup
                popup.style.display = 'none';
            }
        });
    }

    // Aquí podrías inicializar Alpine.js si lo usas
    // document.addEventListener('alpine:init', () => {
    //     Alpine.data('nombreComponente', () => ({
    //         propiedad: 'valor',
    //         metodo() { /* ... */ }
    //     }));
    // });
});
