document.addEventListener('DOMContentLoaded', function () {
    const banner = document.getElementById('cookie-consent-banner');
    const acceptBtn = document.getElementById('cookie-accept-btn');
    const denyBtn = document.getElementById('cookie-deny-btn');
    const prefsBtn = document.getElementById('cookie-prefs-btn');
    const reopenTab = document.getElementById('reopen-cookie-banner-tab'); // Pestaña para reabrir

    const COOKIE_CONSENT_KEY = 'ole_cookie_consent';

    function showBanner() {
        if (banner) banner.style.display = 'block';
        if (reopenTab) reopenTab.style.display = 'none';
    }

    function hideBannerAndShowTab() {
        if (banner) banner.style.display = 'none';
        if (reopenTab) reopenTab.style.display = 'block';
    }

    // Función para establecer el consentimiento
    function setConsent(consentType) {
        localStorage.setItem(COOKIE_CONSENT_KEY, consentType);
        hideBannerAndShowTab();
        console.log('Cookie consent:', consentType);
    }

    // Comprobar si ya existe una preferencia de consentimiento
    const userConsent = localStorage.getItem(COOKIE_CONSENT_KEY);

    if (!userConsent) {
        showBanner(); // Mostrar el banner si no hay preferencia guardada
    } else {
        hideBannerAndShowTab(); // Si hay consentimiento, ocultar banner y mostrar pestaña
        console.log('Cookie consent previously set to:', userConsent);
    }

    // Manejadores de eventos para los botones del banner
    if (acceptBtn) {
        acceptBtn.addEventListener('click', function () {
            setConsent('accepted');
        });
    }

    if (denyBtn) {
        denyBtn.addEventListener('click', function () {
            setConsent('denied');
        });
    }

    if (prefsBtn) {
        prefsBtn.addEventListener('click', function () {
            window.location.href = '/politica-de-cookies';
            // No se establece consentimiento aquí, solo se navega
        });
    }

    // Manejador de evento para la pestaña de reabrir
    if (reopenTab) {
        reopenTab.addEventListener('click', function() {
            localStorage.removeItem(COOKIE_CONSENT_KEY); // Eliminar la preferencia guardada
            showBanner(); // Mostrar el banner principal de nuevo
        });
    }
});
