import re

# Archivo a modificar
file_path = 'o:/IT/Software/OLE CONSULTING/app/services/tariff_detector.py'

# Leer el contenido del archivo
with open(file_path, 'r', encoding='utf-8') as f:
    content = f.read()

# Método que queremos añadir
method_to_add = """
    @staticmethod
    def get_tariff_periods(tariff: str) -> Dict[str, Dict[str, int]]:
        \"\"\"Devuelve la estructura de periodos para cada tipo de peaje.\"\"\"
        if tariff == '2.0TD':
            return {
                'energy': {'P1': 1, 'P2': 2, 'P3': 3},  # 3 periodos de energía
                'power': {'P1': 1, 'P2': 2}            # 2 periodos de potencia
            }
        else:  # 3.0TD o 6.1TD
            return {
                'energy': {'P1': 1, 'P2': 2, 'P3': 3, 'P4': 4, 'P5': 5, 'P6': 6},  # 6 periodos
                'power': {'P1': 1, 'P2': 2, 'P3': 3, 'P4': 4, 'P5': 5, 'P6': 6}   # 6 periodos
            }
"""

# Verificar si el método ya existe
if "def get_tariff_periods" not in content:
    # Añadir el método al final de la clase TariffDetector
    # Buscamos el último método de la clase
    class_content_match = re.search(r'class\s+TariffDetector.*?:(.*)', content, re.DOTALL)
    if class_content_match:
        class_content = class_content_match.group(1)
        # Encontrar la última línea de la clase
        content_with_new_method = content + "\n" + method_to_add
        
        # Guardar el archivo modificado
        with open(file_path, 'w', encoding='utf-8') as f:
            f.write(content_with_new_method)
        print(f"Método añadido correctamente a {file_path}")
    else:
        print("No se pudo encontrar la clase TariffDetector")
else:
    print("El método ya existe en el archivo")
