from app.extensions import db

# Tabla de asociación para la relación muchos-a-muchos User-Role
user_roles = db.Table('user_roles',
    db.Column('user_id', db.Integer, db.ForeignKey('users.id'), primary_key=True),
    db.Column('role_id', db.Integer, db.ForeignKey('roles.id'), primary_key=True)
)

class Role(db.Model):
    __tablename__ = 'roles'
    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(64), unique=True, nullable=False)
    description = db.Column(db.String(255))

    # Relación con User, la contraparte de User.roles
    users = db.relationship('User', secondary=user_roles, back_populates='roles', lazy='dynamic')

    def __repr__(self):
        return f'<Role {self.name}>'
