from app import db
from datetime import datetime

class LegalDocument(db.Model):
    """Modelo para documentos legales como política de cookies, privacidad, etc."""
    __tablename__ = 'legal_documents'
    
    id = db.Column(db.Integer, primary_key=True)
    document_type = db.Column(db.String(50), nullable=False, unique=True)  # cookies, privacy, terms
    title = db.Column(db.String(200), nullable=False)
    content = db.Column(db.Text, nullable=False)
    version = db.Column(db.String(20), default="1.0")
    is_active = db.Column(db.Boolean, default=True)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    updated_at = db.Column(db.DateTime, default=datetime.utcnow, onupdate=datetime.utcnow)
    
    def to_dict(self):
        """Convierte el modelo a diccionario."""
        return {
            'id': self.id,
            'document_type': self.document_type,
            'title': self.title,
            'content': self.content,
            'version': self.version,
            'is_active': self.is_active,
            'updated_at': self.updated_at.strftime('%Y-%m-%d %H:%M:%S'),
        }
    
    @staticmethod
    def get_document(document_type):
        """Obtiene un documento legal por su tipo."""
        return LegalDocument.query.filter_by(document_type=document_type, is_active=True).first()
    
    @staticmethod
    def get_all_documents():
        """Obtiene todos los documentos legales activos."""
        return LegalDocument.query.filter_by(is_active=True).all()
