from app import db
from datetime import datetime

class FAQ(db.Model):
    """Modelo para preguntas frecuentes."""
    __tablename__ = 'faqs'
    
    id = db.Column(db.Integer, primary_key=True)
    question = db.Column(db.String(200), nullable=False)
    answer = db.Column(db.Text, nullable=False)
    order = db.Column(db.Integer, default=0)  # Para controlar el orden de aparición
    is_active = db.Column(db.Boolean, default=True)  # Para activar/desactivar preguntas
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    updated_at = db.Column(db.DateTime, default=datetime.utcnow, onupdate=datetime.utcnow)
    
    def to_dict(self):
        """Convierte el modelo a diccionario."""
        return {
            'id': self.id,
            'question': self.question,
            'answer': self.answer,
            'order': self.order,
            'is_active': self.is_active
        }
