from datetime import datetime
from app.extensions import db

class Contact(db.Model):
    """Modelo para almacenar entradas del formulario de contacto"""
    id = db.Column(db.Integer, primary_key=True)
    name = db.Column(db.String(100), nullable=False)
    email = db.Column(db.String(120), nullable=False)
    phone = db.Column(db.String(20), nullable=True)
    subject = db.Column(db.String(200), nullable=False)
    message = db.Column(db.Text, nullable=False)
    rgpd_consent = db.Column(db.Boolean, default=False, nullable=False)
    newsletter = db.Column(db.Boolean, default=False, nullable=False)
    created_at = db.Column(db.DateTime, default=datetime.utcnow)
    status = db.Column(db.String(20), default='pending', nullable=False)  # pending, processed, archived
    
    def __repr__(self):
        return f'<Contact {self.email}: {self.subject}>'
