from flask_wtf import FlaskForm
from wtforms import StringField, TextAreaField, SubmitField, BooleanField
from wtforms.validators import DataRequired, Email, Length, Optional

class ContactForm(FlaskForm):
    """Formulario de contacto general para el sitio web"""
    name = StringField('Nombre', validators=[DataRequired(), Length(min=3, max=100)])
    email = StringField('Email', validators=[DataRequired(), Email()])
    phone = StringField('Teléfono', validators=[DataRequired(), Length(min=9, max=20)])
    subject = StringField('Asunto', validators=[DataRequired(), Length(min=3, max=100)])
    message = TextAreaField('Mensaje', validators=[DataRequired(), Length(min=10, max=1000)])
    rgpd_consent = BooleanField('Acepto la política de privacidad y el tratamiento de mis datos', 
                               validators=[DataRequired(message='Debes aceptar la política de privacidad')])
    newsletter = BooleanField('Me gustaría recibir informaciones y novedades sobre ahorro energético')
    submit = SubmitField('Enviar Mensaje')
