from flask_sqlalchemy import SQLAlchemy
from flask_migrate import Migrate
from flask_login import LoginManager
from flask_mail import Mail
from flask_bcrypt import Bcrypt
from flask_wtf import CSRFProtect
# from celery import Celery # Descomentar si se usa Celery
import os
from flask_limiter import Limiter
from flask_limiter.util import get_remote_address

db = SQLAlchemy()
migrate = Migrate()
login_manager = LoginManager()
mail = Mail()
bcrypt = Bcrypt()
csrf = CSRFProtect()

# Rate limiting (Flask-Limiter)
# Para producción, se recomienda usar Redis u otro backend persistente via RATELIMIT_STORAGE_URI
# Ejemplo: export RATELIMIT_STORAGE_URI="redis://localhost:6379/3"
limiter = Limiter(
    get_remote_address,
    storage_uri=os.environ.get("RATELIMIT_STORAGE_URI", "memory://"),
)

# Configuración de Flask-Login
login_manager.login_view = 'auth_bp.login' # Endpoint para la página de login
login_manager.login_message = 'Por favor, inicia sesión para acceder a esta página.'
login_manager.login_message_category = 'info'

# Celery (si se usa)
# def make_celery(app):
#     celery = Celery(
#         app.import_name,
#         backend=app.config['CELERY_RESULT_BACKEND'],
#         broker=app.config['CELERY_BROKER_URL']
#     )
#     celery.conf.update(app.config)

#     class ContextTask(celery.Task):
#         def __call__(self, *args, **kwargs):
#             with app.app_context():
#                 return self.run(*args, **kwargs)

#     celery.Task = ContextTask
#     return celery

# celery_app = None # Se inicializará en create_app si se usa Celery
