from flask import render_template, Blueprint
from . import public_bp
from app.models.article import Article
from app.models.faq import FAQ
from app.models.invoice_lead import InvoiceLead
from sqlalchemy import desc

@public_bp.route('/')
def home():
    # Obtener los últimos 6 artículos publicados para mostrar en la página de inicio
    try:
        latest_articles = Article.query.filter(Article.is_published == True).order_by(desc(Article.published_at)).limit(6).all()
        # Convertir a diccionario para evitar problemas con atributos que podrían faltar
        articles = [article.to_dict() for article in latest_articles]
    except Exception as e:
        # En caso de error, mostrar página sin artículos
        print(f"Error al cargar artículos del blog: {e}")
        articles = []
    
    # Obtener las preguntas frecuentes activas ordenadas por el campo order
    try:
        faqs = FAQ.query.filter(FAQ.is_active == True).order_by(FAQ.order).all()
    except Exception as e:
        print(f"Error al cargar las FAQs: {e}")
        faqs = []

    # Últimos estudios con ahorro positivo
    savings = []
    try:
        leads = InvoiceLead.query.order_by(desc(InvoiceLead.submitted_at)).limit(20).all()
        for lead in leads:
            det = lead.details or {}
            amount = det.get('estimated_savings')
            percent = det.get('savings_percent')
            if amount and amount > 0:
                initials = ''.join([p[0].upper()+'.' for p in lead.name.split()[:2]]) if lead.name else 'Cliente'
                savings.append({
                    'initials': initials,
                    'amount': round(amount, 2),
                    'percent': round(percent, 1) if percent else None
                })
            if len(savings) >= 6:
                break
    except Exception as e:
        print(f"Error al cargar ahorros recientes: {e}")
        savings = []
    
    return render_template('public/home.html', title='Inicio', articles=articles, faqs=faqs, savings=savings)

@public_bp.route('/about') # Ejemplo de otra ruta estática
def about():
    return render_template('public/about.html', title='Sobre Nosotros') # Asumimos que existirá templates/public/about.html

# La ruta para /aviso-legal ahora está gestionada en legal_routes.py
# para mostrar el contenido dinámico desde la base de datos

# Las rutas para documentos legales ahora están gestionadas en legal_routes.py
# para mostrar el contenido dinámico desde la base de datos
# - /privacidad (privacy_policy)
# - /cookies (cookies_policy)
# - /aviso-legal (terms_conditions)
