from flask import render_template, abort
from app.models.legal import LegalDocument
from . import public_bp

@public_bp.route('/cookies')
def cookies_policy():
    """Muestra la política de cookies."""
    document = LegalDocument.get_document('cookies')
    if not document:
        abort(404)
    return render_template('public/legal/document.html', document=document)

@public_bp.route('/privacidad')
def privacy_policy():
    """Muestra la política de privacidad."""
    document = LegalDocument.get_document('privacy')
    if not document:
        abort(404)
    return render_template('public/legal/document.html', document=document)

@public_bp.route('/aviso-legal')
def terms_conditions():
    """Muestra el aviso legal."""
    document = LegalDocument.get_document('terms')
    if not document:
        abort(404)
    return render_template('public/legal/document.html', document=document)
