from flask import render_template, redirect, url_for, flash, request, current_app
from datetime import datetime
from app.forms import ContactForm
from app.extensions import db
from app.services.mail_service import send_contact_notification_email
from . import bp as contact_bp

@contact_bp.route('/', methods=['GET', 'POST'])
def contact():
    """Vista para el formulario de contacto general"""
    form = ContactForm()
    
    if form.validate_on_submit():
        try:
            # En una implementación real, aquí guardaríamos los datos en la base de datos
            # y enviaríamos un correo electrónico de notificación
            
            # Ejemplo de código para guardar en base de datos (pendiente de implementar modelo Contact)
            '''
            contact_entry = Contact(
                name=form.name.data,
                email=form.email.data,
                phone=form.phone.data if form.phone.data else None,
                subject=form.subject.data,
                message=form.message.data,
                rgpd_consent=form.rgpd_consent.data,
                newsletter=form.newsletter.data if form.newsletter.data else False,
                created_at=datetime.utcnow()
            )
            db.session.add(contact_entry)
            db.session.commit()
            '''
            
            # Determinar si estamos en modo de desarrollo
            is_development = current_app.config.get('DEBUG', False)
            
            # Intentamos enviar el correo electrónico a ahorro@oleconsulting.es
            try:
                send_contact_notification_email(form.data)
                current_app.logger.info(f"Correo de contacto enviado correctamente a ahorro@oleconsulting.es")
            except Exception as mail_error:
                current_app.logger.error(f"Error al enviar correo: {str(mail_error)}")
                if not is_development:
                    # Si no estamos en desarrollo, propagamos el error
                    raise mail_error
                else:
                    current_app.logger.info("Modo DEBUG: Simulando envío de correo exitoso")
                    # En desarrollo, mostramos los datos que se hubieran enviado
                    current_app.logger.info(f"Destinatario: ahorro@oleconsulting.es")
                    current_app.logger.info(f"Asunto: Nuevo mensaje de contacto - {form.name.data}")
                    current_app.logger.info(f"Datos de contacto: {form.name.data} - {form.email.data} - {form.phone.data}")
            
            # En lugar de redirigir, establecemos un flag para mostrar el mensaje de éxito
            return render_template('contact/contact.html', 
                                 title='Contacta con nosotros', 
                                 form=ContactForm(),  # Nuevo formulario en blanco
                                 show_success=True)
            
        except Exception as e:
            current_app.logger.error(f"Error en formulario de contacto: {str(e)}")
            flash('Error al procesar tu solicitud. Por favor, inténtalo de nuevo más tarde.', 'error')
    
    return render_template('contact/contact.html', title='Contacta con nosotros', form=form)
