from flask import render_template, redirect, url_for, flash, request, Blueprint
from flask_login import login_required #, current_user # Asumimos que solo admin puede acceder
# from app.models.article import Article
# from .forms import ArticleForm # Descomentar cuando el formulario exista
from . import blog_bp # Importamos el blueprint blog_bp
from app.extensions import db

# Podríamos usar un decorador @admin_required si lo implementamos

@blog_bp.route('/admin', methods=['GET'])
@login_required
def admin_dashboard():
    # if not current_user.is_admin: # Ejemplo de comprobación de admin
    #     flash('Acceso no autorizado.', 'danger')
    #     return redirect(url_for('public.home'))
    # articles = Article.query.order_by(Article.created_at.desc()).all()
    # return render_template('admin/blog_dashboard.html', articles=articles, title='Admin Blog')
    return render_template('admin/blog_dashboard_placeholder.html', title='Admin Blog') # Placeholder

@blog_bp.route('/admin/new', methods=['GET', 'POST'])
@login_required
def create_article():
    # if not current_user.is_admin:
    #     return redirect(url_for('public.home'))
    # form = ArticleForm()
    # if form.validate_on_submit():
    #     article = Article(
    #         title=form.title.data,
    #         slug=form.slug.data, # Asegurarse que el slug sea único o generarlo
    #         summary=form.summary.data,
    #         content=form.content.data,
    #         is_published=form.is_published.data,
    #         author_id=current_user.id # Asignar autor si es relevante
    #     )
    #     db.session.add(article)
    #     db.session.commit()
    #     flash('Artículo creado con éxito.', 'success')
    #     return redirect(url_for('blog.admin_dashboard'))
    # return render_template('admin/create_edit_article.html', form=form, title='Nuevo Artículo')
    return render_template('admin/create_edit_article_placeholder.html', title='Nuevo Artículo') # Placeholder

@blog_bp.route('/admin/edit/<int:article_id>', methods=['GET', 'POST'])
@login_required
def edit_article(article_id):
    # if not current_user.is_admin:
    #     return redirect(url_for('public.home'))
    # article = Article.query.get_or_404(article_id)
    # form = ArticleForm(obj=article)
    # if form.validate_on_submit():
    #     article.title = form.title.data
    #     article.slug = form.slug.data
    #     article.summary = form.summary.data
    #     article.content = form.content.data
    #     article.is_published = form.is_published.data
    #     db.session.commit()
    #     flash('Artículo actualizado con éxito.', 'success')
    #     return redirect(url_for('blog.admin_dashboard'))
    # return render_template('admin/create_edit_article.html', form=form, article=article, title='Editar Artículo')
    return render_template('admin/create_edit_article_placeholder.html', title=f'Editar Artículo {article_id}') # Placeholder

@blog_bp.route('/admin/delete/<int:article_id>', methods=['POST']) # Usar POST para acciones destructivas
@login_required
def delete_article(article_id):
    # if not current_user.is_admin:
    #     return redirect(url_for('public.home'))
    # article = Article.query.get_or_404(article_id)
    # db.session.delete(article)
    # db.session.commit()
    # flash('Artículo eliminado con éxito.', 'success')
    # return redirect(url_for('blog.admin_dashboard'))
    flash(f'Artículo {article_id} eliminado (simulado).', 'info')
    return redirect(url_for('blog.admin_dashboard')) # Placeholder
