from flask import Blueprint

# El template_folder se buscará relativo a la carpeta del blueprint
# o globalmente en app/templates/ si no se especifica o no se encuentra aquí.
# Para mantener la modularidad, es común tener una carpeta 'templates' dentro de cada blueprint.
# ej: app/blueprints/blog/templates/blog/list.html
# Se accedería como 'blog/list.html' en render_template si template_folder='templates'
# o simplemente 'list.html' si template_folder='templates/blog'

blog_bp = Blueprint('blog', __name__, template_folder='templates')

from . import routes # Importar rutas
