from flask import jsonify, current_app
from app.models.social_share import SocialNetwork
from . import api_bp

@api_bp.route('/social-networks', methods=['GET'])
def get_social_networks():
    """API para obtener las redes sociales activas y ordenadas"""
    try:
        networks = SocialNetwork.query.filter_by(is_active=True).order_by(SocialNetwork.position).all()
        
        network_list = []
        for network in networks:
            network_list.append({
                'id': network.id,
                'name': network.name,
                'icon': network.icon,
                'color': network.color,
                'url_pattern': network.url_pattern,
                'requires_mobile': network.requires_mobile,
                'position': network.position
            })
        
        return jsonify({
            'success': True,
            'networks': network_list
        })
    
    except Exception as e:
        return jsonify({
            'success': False,
            'error': str(e)
        }), 500
