from flask import jsonify
from app.models.legal import LegalDocument
from . import api_bp

@api_bp.route('/legal/cookie-consent', methods=['GET'])
def get_cookie_consent_data():
    """
    API que devuelve la información necesaria para el banner de consentimiento de cookies.
    Incluye textos del banner y versiones actuales de los documentos legales.
    """
    try:
        # Obtener los documentos legales activos
        cookies_policy = LegalDocument.get_document('cookies')
        privacy_policy = LegalDocument.get_document('privacy')
        terms_policy = LegalDocument.get_document('terms')
        
        # Extraer un fragmento corto del documento de cookies para mostrar en el banner
        cookies_summary = ""
        if cookies_policy and cookies_policy.content:
            # Extraer los primeros 300 caracteres como resumen o usar un texto por defecto
            cookies_summary = cookies_policy.content[:300] + "..." if len(cookies_policy.content) > 300 else cookies_policy.content
        
        # Crear objeto de respuesta
        response = {
            "success": True,
            "data": {
                "banner_title": "Gestionar el consentimiento de las cookies",
                "banner_text": cookies_summary or "Utilizamos cookies propias y de terceros para obtener datos estadísticos de la navegación de nuestros usuarios, ofrecer marketing personalizado y mejorar nuestros servicios.",
                "documents": {
                    "cookies": {
                        "title": cookies_policy.title if cookies_policy else "Política de Cookies",
                        "url": "/cookies",
                        "version": cookies_policy.version if cookies_policy else "1.0"
                    },
                    "privacy": {
                        "title": privacy_policy.title if privacy_policy else "Política de Privacidad",
                        "url": "/privacidad",
                        "version": privacy_policy.version if privacy_policy else "1.0"
                    },
                    "terms": {
                        "title": terms_policy.title if terms_policy else "Aviso Legal",
                        "url": "/aviso-legal",
                        "version": terms_policy.version if terms_policy else "1.0"
                    }
                }
            }
        }
        
        return jsonify(response)
    except Exception as e:
        return jsonify({"success": False, "error": str(e)}), 500
