from flask import Blueprint

admin_bp = Blueprint('admin', __name__, url_prefix='/admin')

# Importar rutas después de crear el blueprint para evitar importaciones circulares
from . import routes
from . import blog_routes
from . import social_routes
from . import faq_routes
from . import legal_routes
from . import api_routes

def init_app(app):
    """
    Inicializa la aplicación con comandos y configuraciones específicas del blueprint admin.
    """
    # Registrar comandos CLI
    from .commands import register_commands
    register_commands(app)
