from app import create_app
from app.models.article import Article
from app.extensions import db
from datetime import datetime
import random

def main():
    app = create_app()
    
    with app.app_context():
        # Eliminar artículos existentes para evitar duplicados
        existing_articles = Article.query.all()
        print(f"Artículos existentes: {len(existing_articles)}")
        
        # Nuevos artículos con información real sobre el mercado eléctrico español
        articles = [
            {
                'title': 'España marca un récord en generación renovable en 2024',
                'summary': 'Las energías renovables alcanzaron un 56,4% de la producción eléctrica nacional en el primer trimestre, estableciendo un nuevo récord histórico.',
                'content': '''
                <p>El sistema eléctrico español ha alcanzado un nuevo hito en su transición energética, con las renovables generando el 56,4% de toda la electricidad durante el primer trimestre de 2024, según datos de Red Eléctrica de España (REE).</p>
                
                <p>Este récord supone un incremento del 7,2% respecto al mismo periodo del año anterior y confirma la tendencia hacia un mix energético cada vez más limpio. La eólica ha sido la principal fuente de generación, aportando un 27,3% del total, seguida por la hidráulica (15,8%) y la solar fotovoltaica (11,2%).</p>
                
                <p>La vicepresidenta tercera y ministra para la Transición Ecológica, Teresa Ribera, ha destacado que "estos datos demuestran que España avanza con firmeza hacia sus objetivos climáticos y de descarbonización".</p>
                
                <p>Los expertos señalan que este incremento ha contribuido a mantener precios más estables en el mercado mayorista de electricidad, beneficiando tanto a consumidores domésticos como industriales en un contexto de volatilidad energética internacional.</p>
                ''',
                'is_published': True,
                'published_at': datetime(2024, 5, 15)
            },
            {
                'title': 'Nueva normativa de autoconsumo facilita la instalación de paneles solares',
                'summary': 'El Gobierno aprueba un Real Decreto que simplifica los trámites administrativos para instalaciones de autoconsumo y comunidades energéticas.',
                'content': '''
                <p>El Consejo de Ministros ha aprobado un Real Decreto que simplifica drásticamente los trámites administrativos para la instalación de sistemas de autoconsumo energético, eliminando barreras burocráticas que frenaban su expansión.</p>
                
                <p>La nueva normativa reduce los plazos de autorización, elimina la necesidad de permisos para instalaciones de menos de 15 kW en suelo urbanizado y establece un régimen especial para comunidades energéticas. Además, contempla un nuevo esquema de compensación de excedentes más beneficioso para los autoconsumidores.</p>
                
                <p>"Con esta medida, España se sitúa a la vanguardia europea en la promoción del autoconsumo energético", ha declarado el ministro para la Transición Ecológica. Se espera que esta normativa impulse la instalación de hasta 5 GW adicionales de potencia fotovoltaica en tejados durante los próximos tres años.</p>
                
                <p>Las asociaciones del sector han recibido con satisfacción la medida, aunque solicitan mayor claridad en algunos aspectos técnicos como la gestión de la potencia contratada en instalaciones colectivas.</p>
                ''',
                'is_published': True,
                'published_at': datetime(2024, 6, 2)
            },
            {
                'title': 'La factura eléctrica baja un 15% en el último trimestre',
                'summary': 'La caída de precios en el mercado mayorista se traslada al consumidor final tras meses de precios elevados.',
                'content': '''
                <p>Los consumidores españoles han experimentado un alivio en su factura eléctrica durante el último trimestre, con una reducción media del 15% respecto al mismo periodo del año anterior, según datos de la Comisión Nacional de los Mercados y la Competencia (CNMC).</p>
                
                <p>Esta bajada se debe principalmente a la combinación de varios factores: la mayor generación renovable, la estabilización de los precios del gas natural en los mercados internacionales y el buen funcionamiento del mecanismo ibérico de limitación del precio del gas para la generación eléctrica.</p>
                
                <p>El precio medio del megavatio hora (MWh) en el mercado mayorista se situó en 82,30 euros durante abril y mayo, frente a los 135,42 euros del mismo periodo en 2023. Las comercializadoras han trasladado progresivamente esta bajada a los consumidores finales, tanto en el mercado regulado como en el libre.</p>
                
                <p>Las organizaciones de consumidores valoran positivamente esta tendencia, aunque señalan que los precios siguen siendo superiores a los niveles previos a la crisis energética de 2021. Las previsiones apuntan a que esta tendencia a la baja podría moderarse durante los meses de verano debido al incremento estacional de demanda por climatización.</p>
                ''',
                'is_published': True,
                'published_at': datetime(2024, 6, 5)
            }
        ]
        
        # Añadir los artículos a la base de datos
        for article_data in articles:
            # Verificar si ya existe un artículo con el mismo título
            existing_article = Article.query.filter_by(title=article_data['title']).first()
            if existing_article:
                print(f"Actualizando artículo existente: {article_data['title']}")
                # Actualizar campos
                for key, value in article_data.items():
                    setattr(existing_article, key, value)
            else:
                print(f"Creando nuevo artículo: {article_data['title']}")
                article = Article(
                    title=article_data['title'],
                    summary=article_data['summary'],
                    content=article_data['content'],
                    is_published=article_data['is_published'],
                    published_at=article_data['published_at']
                )
                db.session.add(article)
        
        # Guardar cambios
        try:
            db.session.commit()
            print("Artículos añadidos/actualizados correctamente")
            # Mostrar artículos actuales
            articles = Article.query.all()
            print(f"Total de artículos en la base de datos: {len(articles)}")
            for article in articles:
                print(f"- {article.title} (Publicado: {article.is_published})")
        except Exception as e:
            db.session.rollback()
            print(f"Error al guardar los artículos: {e}")

if __name__ == "__main__":
    main()
