# OLE CONSULTING
Pagina web OLE CONSULTING

## IMPORTANTE

La carpeta de uploads en la raíz del proyecto no puede ser reemplazada a la hora de actualizar el proyecto en el servidor, esta contiene la dirección url que se tiene que usar al momento de visualizar los artículos, es de suma importancia borrar la carpeta de uploads en el zip que se va a subir a servidor.

## Gestión de Migraciones de Base de Datos

Este proyecto utiliza Flask-Migrate (Alembic) para gestionar las migraciones de la base de datos. A continuación se detallan los comandos principales para trabajar con migraciones:

### Comandos Básicos de Migración

```bash
# Inicializar el sistema de migraciones (solo la primera vez)
python db_migrate.py init

# Crear una nueva migración cuando se modifiquen los modelos
python db_migrate.py migrate "descripción_de_los_cambios"

# Aplicar todas las migraciones pendientes
python db_migrate.py upgrade

# Revertir la última migración aplicada
python db_migrate.py downgrade

# Revertir a una revisión específica
python db_migrate.py downgrade revisión_específica
```

### Seeders para Datos Iniciales

#### Sembrar Roles

Para inicializar o actualizar los roles en la base de datos:

```bash
# Usando el script de inicialización de roles
python init_roles.py

# Usando el script específico para sembrar roles con SQL directo
python seed_roles.py
```

Los roles predefinidos son:
1. Super Administrador - Acceso total a todas las funcionalidades
2. Agente - Puede ver leads, pero no descargar archivos adjuntos ni eliminar leads
3. Blogger - Puede crear y gestionar artículos del blog y entradas FAQ
4. Analista de precios - Solo puede gestionar/cargar las tarifas de energia
5. Comercial - Puede ver tarifas y leads, pero no puede modificar o eliminar registros

### Crear Nuevos Seeders

Para crear nuevos seeders para otras tablas:

1. **Opción 1: Script Python independiente**
   - Crear un archivo similar a `seed_roles.py` adaptado a la tabla deseada
   - Ejecutar con `python nombre_del_script.py`

2. **Opción 2: Migración Alembic**
   - Crear un archivo en `migrations/versions/` siguiendo el patrón de `seed_roles_migration.py`
   - Asegurarse de establecer correctamente `revision` y `down_revision`
   - Aplicar con `python db_migrate.py upgrade`

### Creación de sesión "detached" (segundo plano) en servidor con gunicorn

```bash
   screen -dmS ole_app bash -c "cd /home/oleconsulting/public_html && source venv/bin/activate && export OPENAI_API_KEY='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' && export FLASK_CONFIG=production && gunicorn -w 4 -b 0.0.0.0:9000 --timeout 10000 run:app"
```

## Para detener proceso en gunicorn

```bash
   screen -X -S ole_app quit
```